/**
 * \file: mspin_connection_tcp.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * mySPIN Connection Adapter TCP/IP
 *
 * \component: MSPIN
 *
 * \author: Thilo Bjoern Fickel BSOT/PJ-ES1 thilo.fickel@bosch-softtec.com
 *
* \copyright: (c) 2016 Bosch SoftTec GmbH
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_CONNECTION_TCP_H_
#define MSPIN_CONNECTION_TCP_H_

#include "mspin_typedef.h"
#include "mspin_appl_if_adapter.h"

//#define MSPIN_TCP_USE_MESSAGE_QUEUE //comment in to use message queue

#define MSPIN_UDP_MESSAGE_PREFIX "mySPINd"

#ifdef MSPIN_TCP_USE_MESSAGE_QUEUE
#define MSPIN_TCP_READ_BUFFER_SIZE 16384 //adjustments required here for performance improvements?
#endif //MSPIN_TCP_USE_MESSAGE_QUEUE

S32 mspin_tcp_receive(mspin_connectionHandle_t *pConnectionHandle, U8* buffer, U32 bufferLen, U32 timeout);

S32 mspin_tcp_send(mspin_connectionHandle_t *pConnectionHandle, const U8* buffer, U32 bufferLen);

#endif /* MSPIN_CONNECTION_TCP_H_ */
